#' Data on customer spending, subscriptions, and churn.
#'
#' A simulated dataset of customer spending used to demonstrate the functionality of the instruments package.
#'
#' \itemize{
#'   \item baseline_spending. latent variable with customers' baseline spending rate.
#'   \item incentive.  binary variable indicating whether customer was offered an incentive.
#'   \item subscription. whether customer has a subscription.
#'   \item total_spending. total spending over a given period.
#'   \item churn. binary variable indicating whether customer has churned.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name subscriptions
#' @usage data(subscriptions)
#' @format A data frame with 100000 rows and 5 variables
NULL