% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period_to_months.R
\name{period_to_months}
\alias{period_to_months}
\title{Split period to months}
\usage{
period_to_months(df, begin, end, ...)
}
\arguments{
\item{df}{data.frame}

\item{begin}{column in \code{df} with begin dates}

\item{end}{column in \code{df} with end dates}

\item{...}{numeric columns in df to split}
}
\value{
data.frame with same columns as in df, and one extra column called id
}
\description{
The function splits rows with a time period longer than one month to multiple rows with a time period of exactly one month each.
Values in numeric columns (e.g. exposure or premium) are divided over the months proportionately.
}
\details{
In insurance portfolios it is common that rows relate to periods longer than one month.
This is for example problematic in case exposures per month are desired.

Since insurance premiums are constant over the months, and do not depend on the number of days per month, the function assumes that each month
has the same number of days (i.e. 30).
}
\examples{
library(lubridate)
portfolio <- data.frame(
begin1 = ymd(c("2014-01-01", "2014-01-01")),
end = ymd(c("2014-03-14", "2014-05-10")),
termination = ymd(c("2014-03-14", "2014-05-10")),
exposure = c(0.2025, 0.3583),
premium =  c(125, 150))
period_to_months(portfolio, begin1, end, premium, exposure)


}
\author{
Martin Haringa
}
