% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_refinement.R
\name{restrict_coef}
\alias{restrict_coef}
\title{Restrict coefficients in the model}
\usage{
restrict_coef(model, restrictions)
}
\arguments{
\item{model}{object of class glm/restricted}

\item{restrictions}{data.frame with two columns containing restricted data.
The first column, with the name of the risk factor as column name, must
contain the levels of the risk factor. The second column must contain the
restricted coefficients.}
}
\value{
Object of class restricted.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Add restrictions, like a bonus-malus structure, on the risk
factors used in the model. \code{restrict_coef()} must always be followed
by \code{update_glm()}.
}
\details{
Although restrictions could be applied either to the frequency or
the severity model, it is more appropriate to impose the restrictions
on the premium model. This can be achieved by calculating the pure
premium for each record (i.e. expected number of claims times the expected
claim amount), then fitting an "unrestricted" Gamma GLM to the pure
premium,and then imposing the restrictions in a final "restricted" Gamma
GLM.
}
\examples{
\dontrun{
# Add restrictions to risk factors for region (zip) -------------------------

# Fit frequency and severity model
library(dplyr)
freq <- glm(nclaims ~ bm + zip, offset = log(exposure), family = poisson(),
             data = MTPL)
sev <- glm(amount ~ bm + zip, weights = nclaims,
            family = Gamma(link = "log"),
            data = MTPL |> filter(amount > 0))

# Add predictions for freq and sev to data, and calculate premium
premium_df <- MTPL |>
   add_prediction(freq, sev) |>
   mutate(premium = pred_nclaims_freq * pred_amount_sev)

# Restrictions on risk factors for region (zip)
zip_df <- data.frame(zip = c(0,1,2,3), zip_rst = c(0.8, 0.9, 1, 1.2))

# Fit unrestricted model
burn <- glm(premium ~ bm + zip, weights = exposure,
            family = Gamma(link = "log"), data = premium_df)

# Fit restricted model
burn_rst <- burn |>
  restrict_coef(restrictions = zip_df) |>
  update_glm()

# Show rating factors
rating_factors(burn_rst)
}

}
\seealso{
\code{\link[=update_glm]{update_glm()}} for refitting the restricted model,
and \code{\link[=autoplot.restricted]{autoplot.restricted()}}.

Other update_glm: 
\code{\link{smooth_coef}()}
}
\author{
Martin Haringa
}
\concept{autoplot.restricted}
\concept{update_glm}
