\name{estim.regul}
\encoding{latin1}
\alias{estim.regul}
\alias{estim.regul.default}

\title{Estimate the parameters of regularization for Regularized CCA}

\description{
Computes leave-one-out or M-fold cross-validation scores on a two-dimensional 
grid to determine optimal values for the parameters of regularization in 
\code{rcc}.
}

\usage{
estim.regul(X, Y, grid1 = NULL, grid2 = NULL, 
            validation = c("loo", "Mfold"), 
            folds, M = 10, plt = TRUE, ...)
}

\arguments{
  \item{X}{numeric matrix or data frame \eqn{(n \times p)}, the observations on the \eqn{X} variables.
    \code{NA}s are allowed.}
  \item{Y}{numeric matrix or data frame \eqn{(n \times q)}, the observations on the \eqn{Y} variables.
    \code{NA}s are allowed.}
  \item{grid1, grid2}{vector numeric defining the values of \code{lambda1} and \code{lambda2} 
	at which cross-validation score should be computed. Defaults to 
	\code{lambda1 = lambda2 = seq(from=0.001, to=1, length=5)}.}
  \item{validation}{character string. What kind of (internal) cross-validation method to use, 
    (partially) matching one of \code{"loo"} (leave-one-out) or \code{"Mfolds"} (M-folds). See Details.}
  \item{folds}{list of vectors (as returned by \code{\link{split}}) 
	containing the indices for the validation sample (see Details).}	
  \item{M}{positive integer. Number of folds to use if \code{validation="Mfold"}. Defaults to
    \code{M=10}.}
  \item{plt}{logical argument indicating whether a image map should be
	plotted by calling the \code{imgCV} function.}
  \item{...}{not used currently.}	
}

\details{
If \code{validation="Mfolds"}, M-fold cross-validation is performed by calling 
\code{Mfold}. When \code{folds} is given, the elements of \code{folds} should be integer vectors 
specifying the indices of the validation sample and the argument \code{M} is
ignored. Otherwise, the folds are generated. The number of cross-validation 
folds is specified with the argument \code{M}. 

If \code{validation="loo"}, 
leave-one-out cross-validation is performed by calling the 
\code{loo} function. In this case the arguments \code{folds} and \code{M} are ignored.
}

\value{
The returned value is a list with components: 
  \item{opt.lambda1,}{}
  \item{opt.lambda2}{value of the parameters of regularization on which
    the cross-validation method reached it optimal.}
  \item{opt.score}{the optimal cross-validation score reached on the grid.}
  \item{grid1, grid2}{original vectors \code{grid1} and \code{grid2}.} 
  \item{mat}{matrix containing the cross-validation score computed on the grid.}
}

\author{Sbastien Djean and Ignacio Gonzlez.}

\seealso{\code{\link{loo}}, \code{\link{Mfold}}, \code{\link{image.estim.regul}}.}

\examples{
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene

## this can take some seconds
estim.regul(X, Y, validation = "Mfold")
}

\keyword{multivariate}
\keyword{dplot}
