% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_check_types.R
\name{check_integer}
\alias{check_integer}
\title{Checks a set of variables can be coerced to integer and coerces them}
\usage{
check_integer(
  ...,
  .message = "`{param}` is not an integer ({err}).",
  .env = rlang::caller_env()
)
}
\arguments{
\item{...}{a list of symbols}

\item{.message}{a glue specification containing \code{{param}} as the name of the
parameter and \code{{err}} the cause of the error}

\item{.env}{the environment to check (defaults to calling environment)}
}
\value{
nothing. called for side effects. throws error if not all variables can be coerced.
}
\description{
N.B. This only works for the specific environment (to prevent weird side effects)
}
\examples{
a = c(1:4)
b = c("1",NA,"3")
f = NULL
g = NA
check_integer(a,b,f,g)

c = c("dfsfs")
e = c(1.0,2.3)
try(check_integer(c,d,e, mean))
}
\concept{parameter_checks}
