% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yupana_analysis.R
\name{yupana_analysis}
\alias{yupana_analysis}
\title{Fieldbook analysis report}
\usage{
yupana_analysis(
  data,
  last_factor = NULL,
  response,
  model_factors,
  comparison,
  test_comp = "SNK",
  sig_level = 0.05,
  plot_dist = "boxplot",
  plot_diag = FALSE,
  digits = 2
)
}
\arguments{
\item{data}{Field book data.}

\item{last_factor}{The last factor in your fieldbook.}

\item{response}{Response variable.}

\item{model_factors}{Model used for the experimental design.}

\item{comparison}{Factors to compare}

\item{test_comp}{Comprasison test c("SNK", "TUKEY", "DUNCAN")}

\item{sig_level}{Significal test (default: p = 0.005)}

\item{plot_dist}{Plot data distribution (default = "boxplot")}

\item{plot_diag}{Diagnostic plots for model (default = FALSE).}

\item{digits}{Digits number in the table exported.}
}
\value{
list
}
\description{
Function to create a complete report of the fieldbook
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

yrs <- yupana_analysis(data = fb
                       , last_factor = "bloque"
                       , response = "spad_83"
                       , model_factors = "block + geno + treat"
                       , comparison = c("geno", "treat")
                       )
                       
yrs$meancomp

yrs$anova \%>\% summary()

}

}
