% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_base_normal.R
\name{sim_base_normal}
\alias{sim_base_normal}
\title{sim_Base_normal}
\usage{
sim_base_normal(
  demand,
  mean,
  sd,
  leadtime,
  service_level,
  Base = FALSE,
  ordering_delay = FALSE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.}

\item{sd}{standard deviation in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Base}{Set to False for automatic calculation,else manual input of base.}

\item{ordering_delay}{logical,Default is FALSE,if TRUE, orders are delayed one period.}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}

\item{ordering_cost}{ordering cost for every time an order is made.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Base Stock  policy.
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated based on a 
 normal distribution.
the base is calculated automatically based on the mean demand and standard deviaiton. every period the order is exactly as the sales.
}
\examples{
sim_base_normal(demand=rpois(80,6),mean=6,sd=0.2,leadtime=5,service_level=0.95,Base = 50,
shortage_cost= 1,inventory_cost=1,ordering_cost=1,ordering_delay=FALSE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
