% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_base_stock_policy.R
\name{sim_base_stock_policy}
\alias{sim_base_stock_policy}
\title{sim_base_stock_policy}
\usage{
sim_base_stock_policy(
  demand,
  mean = FALSE,
  sd = FALSE,
  leadtime,
  service_level,
  Base = FALSE,
  ordering_delay = FALSE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE,
  distribution = "normal",
  recalculate = FALSE,
  recalculate_windows = FALSE,
  plot = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.default is FALSE and is automatically calculated. otherwise set manually.}

\item{sd}{standard deviation in N time periods.default is FALSE and is automatically calculated. otherwise set manually.}

\item{leadtime}{lead time from order to arrival (order to delivery time)}

\item{service_level}{cycle service level requested}

\item{Base}{integer,Default is False and calculated based on mean and sd(normal) or rate of demand (poisson)}

\item{ordering_delay}{logical,Default is FALSE,if TRUE, orders are delayed one period.}

\item{shortage_cost}{numeric,Default is FALSE shortage cost per unit of sales lost}

\item{inventory_cost}{numeric,Default is FALSE inventory cost per unit.}

\item{ordering_cost}{numeric,Default is FALSE ordering cost for every time an order is made.}

\item{distribution}{distribution  to calculate safety stock based on demand distribution, current choices are 'normal' or 'poisson'}

\item{recalculate}{integer, the mean and sd is recalculated every X periods from first period to x,default is FALSE .}

\item{recalculate_windows}{integer, the min  mean and sd windows to recalculate , for exammple if it is set to 4 mean and sd
is calculated from t to t-4,,default is FALSE .}

\item{plot}{Logical, Default is False, if true a plot is generated}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a  base stock policy 
where order is made every period equal to the demand sold and having a Base stock enough for leadtime and saftey stock.
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate an inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. 
 the min is calculated based on a normal distribution or a poisson distribution, also min can be set manually.
 demand and base adjustment (if any) is ordered every period.
}
\examples{
sim_base_stock_policy(demand = rpois(90,8),leadtime = 6,service_level = 0.95,recalculate = 5)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
