% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegularizedLaplacian.R
\name{RegularizedLaplacian}
\alias{RegularizedLaplacian}
\alias{transform,RegularizedLaplacian,Matrix-method}
\alias{transform,RegularizedLaplacian,matrix-method}
\alias{transform,RegularizedLaplacian,sparseLRMatrix-method}
\alias{inverse_transform,RegularizedLaplacian,Matrix-method}
\alias{inverse_transform,RegularizedLaplacian,matrix-method}
\alias{inverse_transform,RegularizedLaplacian,vsp_fa-method}
\title{Construct and use the Regularized Laplacian}
\usage{
RegularizedLaplacian(A, tau_row = NULL, tau_col = NULL)

\S4method{transform}{RegularizedLaplacian,Matrix}(iform, A)

\S4method{transform}{RegularizedLaplacian,matrix}(iform, A)

\S4method{transform}{RegularizedLaplacian,sparseLRMatrix}(iform, A)

\S4method{inverse_transform}{RegularizedLaplacian,Matrix}(iform, A)

\S4method{inverse_transform}{RegularizedLaplacian,matrix}(iform, A)

\S4method{inverse_transform}{RegularizedLaplacian,vsp_fa}(iform, A)
}
\arguments{
\item{A}{A matrix to transform.}

\item{tau_row}{Additive regularizer for row sums of \code{abs(A)}. Typically
this corresponds to inflating the (absolute) out-degree of each node
by \code{tau_row}. Defaults to \code{NULL}, in which case we set \code{tau_row} to
the mean (absolute) row sum of \code{A}.}

\item{tau_col}{Additive regularizer for column sums of \code{abs(A)}. Typically
this corresponds to inflating the (absolute) in-degree of each node
by \code{tau_col}. Defaults to \code{NULL}, in which case we set \code{tau_col} to
the mean (absolute) column sum of \code{A}.}

\item{iform}{An \linkS4class{Invertiform} object describing the transformation.}
}
\value{
\itemize{
\item \code{RegularizedLaplacian()} creates a \linkS4class{RegularizedLaplacian} object.
\item \code{transform()} returns the transformed matrix,
typically as a \linkS4class{Matrix}.
\item \code{inverse_transform()} returns the inverse transformed matrix,
typically as a \linkS4class{Matrix}.
}
}
\description{
Construct and use the Regularized Laplacian
}
\details{
We define the \emph{regularized Laplacian} \eqn{L^\tau(A)}{L_tau(A)} of an
\eqn{n \times n}{n by n} graph adjacency matrix \eqn{A} as

\deqn{
  L^\tau(A)_{ij} = \frac{A_{ij}}{\sqrt{d^{out}_i + \tau_{row}}
  \sqrt{d^{in}_j + \tau_{col}}}
}{
  L[ij] = A[ij] / (sqrt(d^out[i] + \tau_row)  sqrt(d^in[j] + \tau_col))
}

where

\deqn{
  d^{out}_i = \sum_{j=1}^n \| A_{ij} \|
}{
  d^out[i] = sum_j abs(A[ij])
}

and

\deqn{
  d^{in}_j = \sum_{i=1}^n \| A_{ij} \|.
}{
  d^in[j] = sum_i abs(A[ij]).
}

When \eqn{A_{ij}}{A[ij]} denotes the present of an edge \emph{from} node \eqn{i}
\emph{to} node \eqn{j}, which is fairly standard notation,
\eqn{d^{out}_i}{d^out[i]} denotes the (absolute) out-degree of node
\eqn{i} and \eqn{d^{in}_j}{d^in[j]} denotes the (absolute) in-degree
of node \eqn{j}. Then \eqn{\tau_{row}}{\tau_row} is an additive
out-degree regularizer and \eqn{\tau_{col}}{\tau_col} is an
additive in-degree regularizer.

Note that this documentation renders more clearly at
\url{https://rohelab.github.io/invertiforms/}.
}
\examples{

library(igraph)
library(igraphdata)

data("karate", package = "igraphdata")

A <- get.adjacency(karate)

iform <- RegularizedLaplacian(A)

L <- transform(iform, A)
L

A_recovered <- inverse_transform(iform, L)

all.equal(A, A_recovered)

}
