% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotable_year_get.R
\name{iotable_year_get}
\alias{iotable_year_get}
\title{Get Available Years For Input-Output Tables}
\usage{
iotable_year_get(
  labelled_io_data = NULL,
  source = "germany_1990",
  geo = "DE",
  unit = "MIO_EUR",
  time_unit = "year",
  stk_flow = "TOTAL",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{labelled_io_data}{If you have downloaded a bulk data file with 
\code{\link{iotables_download}}, it is faster to work with the data
in the memory. Defaults to \code{NULL} when  the data will be retrieved from
the hard disk or from the Eurostat website invoking the same function.}

\item{source}{A data source, for example \code{naio_10_cp1700}. 
Symmetric input-output table at basic prices (product by product) (naio_10_cp1700)    
Symmetric input-output table at basic prices (industry by industry) (naio_10_cp1750)
Symmetric input-output table at basic prices (product by product) (previous years prices) (naio_10_pyp1700)
Symmetric input-output table at basic prices (industry by industry) (previous years prices) (naio_10_pyp1750)
Table of trade and transport margins at basic prices (naio_10_cp1620) and 
at previous' years prices (naio_10_pyp1620)
Table of taxes less subsidies on products at basic prices (naio_10_cp1630)    and
at previous' years prices (naio_10_pyp1630)
For further information consult the 
\href{https://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/overview}{Eurostat Symmetric Input-Output Tables} page.}

\item{geo}{A country code or a country name.  For example, \code{SK} or as \code{Slovakia}.}

\item{unit}{A character string containing the currency unit, defaults to \code{MIO_NAC} (million national currency unit). 
The alternative is \code{MIO_EUR}.}

\item{time_unit}{Defaults to \code{'year'} and years are returned as numbers. 
Alternative is to return  \code{'time'} as vector of dates.}

\item{stk_flow}{Defaults to \code{DOM} as domestic output, alternative \code{IMP} for imports 
and \code{TOTAL} for total output. For \code{source = 'naio_10_cp1620'} and 
trade and transport margins and  \code{source = 'naio_10_cp1630'} taxes 
less subsidies only \code{TOTAL} is not used.}

\item{data_directory}{Defaults to \code{NULL}. Use if it you used a data_directory
parameter with \code{\link{iotable_get}} or \code{\link{iotables_download}}.}

\item{force_download}{Defaults to \code{TRUE}. If \code{FALSE} it will use the existing 
downloaded file in the \code{data_directory} or the temporary directory, 
if it exists. Will force download only in a new session.}
}
\value{
A vector with the years that have available input-output tables.
}
\description{
The function selects the available tables by year or time as a date 
for a specific country and currency unit in the Eurostat bulk file.
Unless you want to work with bulk data files, you should not invoke  \code{\link{iotables_download}} 
directly, rather via this function, if and when it is necessary.
}
\examples{
germany_years <- iotable_year_get ( source = "germany_1990", geo = 'DE', 
                                    unit = "MIO_EUR" )
}
