% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_tax_add.R
\name{total_tax_add}
\alias{total_tax_add}
\title{Summarize And Add Tax Data}
\usage{
total_tax_add(
  data_table,
  tax_names = c("d21x31", "d29x39"),
  total_tax_name = "TOTAL_TAX"
)
}
\arguments{
\item{data_table}{A SIOT, a use table, a supply table, or a margins 
table that 
has product and production tax rows in among the primary inputs.}

\item{tax_names}{Defaults to \code{("d21x31", "d29x39")}, 
which are the Eurostat 
names for taxes. The parameter is not case sensitive.}

\item{total_tax_name}{Defaults to \code{'TOTAL_TAX'}. The name of the 
summarized row. It is case sensitive.}
}
\value{
A data frame with the vector of multipliers and the an 
auxiliary metadata column (for joining with other matrixes.)
}
\description{
Summarize And Add Tax Data
}
\examples{
de_io <- iotable_get ()

total_tax_add ( de_io, 
                tax_names = c("net_tax_products",  "net_tax_production"),
                total_tax_name = "total_tax")
}
