% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leontief_inverse_create.R
\name{leontief_inverse_create}
\alias{leontief_inverse_create}
\alias{leontieff_inverse_create}
\title{Create the inverse of a Leontief-matrix}
\usage{
leontief_inverse_create(technology_coefficients_matrix, digits = NULL)

leontieff_inverse_create(technology_coefficients_matrix, digits = NULL)
}
\arguments{
\item{technology_coefficients_matrix}{A technology coefficient matrix created
by the \code{\link{input_coefficient_matrix_create}}.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}
}
\description{
Create the Leontief inverse from the technology coefficient matrix.
}
\details{
The Leontief-inverse is \deqn{L = (I-A)^-1}
where B is the input coefficient matrix
created by \code{\link{input_coefficient_matrix_create}}. For the similar inverse 
created from output coefficients, see the 
\code{\link{ghosh_inverse_create}} function.
}
\examples{
tm <- input_flow_get ( 
  data_table = iotable_get(), 
  households = FALSE)
I <- leontief_inverse_create( technology_coefficients_matrix = tm )
}
\seealso{
Other analytic object functions: 
\code{\link{ghosh_inverse_create}()},
\code{\link{input_flow_get}()},
\code{\link{leontief_matrix_create}()}
}
\concept{analytic object functions}
