# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'Generating randomly chosen probabilities for Assignment Error Matrix
#'
#'Function written in \code{C++} for generating a set of randomly chosen
#'probabilities for the Assignment Error Matrix.
#'@param n_categories Integer for the number of categories in the data. Must be
#'at least 2.
#'@return Returns a matrix for Assignment Error Matrix (AEM) with randomly
#'generated probabilities. The generated probabilities are in line with
#'the assumption of weak superiority.
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
get_random_start_values_p <- function(n_categories) {
    .Call('_iotarelr_get_random_start_values_p', PACKAGE = 'iotarelr', n_categories)
}

#'Generating randomly chosen probabilities for categorical sizes
#'
#'Function written in \code{C++} for generating a set of randomly chosen
#'probabilities describing the size of the different classes. The
#'probabilities describe the relative frequencies of the categories in the data.
#'@param n_categories Integer for the number of categories in the data. Must be
#'at least 2.
#'@return Returns a vector of randomly chosen categorical sizes.
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
get_random_start_values_class_sizes <- function(n_categories) {
    .Call('_iotarelr_get_random_start_values_class_sizes', PACKAGE = 'iotarelr', n_categories)
}

#' Estimating log-likelihood
#'
#' Function written in \code{C++} estimating the log likelihood of a given
#' parameter set.
#'
#' @param categorial_sizes \code{Vector} containing the sizes of the different
#' categories. That is amount of a category on all cases.
#' @param aem \code{Matrix} in aem form. This matrix reports the true category
#' in the rows and the assigned categories in the columns. The cells represent
#' the probabilities that a coding unit of category i is assigned to category j.
#' @param obs_pattern_shape \code{Matrix} containing the unique patterns found
#' in the data. Ideally this matrix is generated by the function
#' \code{get_patterns()}.
#' @param obs_pattern_frq \code{Vector} containing the frequencies of the
#' patterns. Ideally it is generated by the the function
#' \code{get_patterns()}.
#' @param categorical_levels \code{Vector} containing all possible categories of
#' the content analysis.
#' @return Returns the log likelihood as a single numeric value.
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
fct_log_likelihood_c <- function(categorial_sizes, aem, obs_pattern_shape, obs_pattern_frq, categorical_levels) {
    .Call('_iotarelr_fct_log_likelihood_c', PACKAGE = 'iotarelr', categorial_sizes, aem, obs_pattern_shape, obs_pattern_frq, categorical_levels)
}

#' Estimating log-likelihood in Condition Stage
#'
#' Function written in \code{C++} estimating the log likelihood of a given
#' parameter set during the condition stage.
#'
#' @param probabilities \code{NumericVector} containing the probabilities of
#' a multinominal distribution. In the context of Iota Reliability this refers
#' to a specific row of the Assignment Error Matrix.
#' @param observations \code{NumericVector} containing the number of
#' observations for each category of the multinominal distribution.
#' @return Returns the log likelihood as a single numeric value.
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
log_likelihood_multi_c <- function(probabilities, observations) {
    .Call('_iotarelr_log_likelihood_multi_c', PACKAGE = 'iotarelr', probabilities, observations)
}

#' Gradient for Log Likelihood in Condition Stage
#'
#' Function written in \code{C++} estimating the gradient of the log likelihood
#' function for a given parameter set and given observations.
#'
#' @param param_values \code{NumericVector} containing the probabilities of
#' a multinominal distribution. The length of this factor is the number of
#' categories - 1 since it contains only the parameters to be estimated.
#' @param observations \code{NumericVector} containing the number of
#' observations for each category of the multinominal distribution. The length
#' of this vector equals the number of categories.
#' @return Returns the gradient as a \code{NumericVector}.
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
grad_ll <- function(param_values, observations) {
    .Call('_iotarelr_grad_ll', PACKAGE = 'iotarelr', param_values, observations)
}

#' Estimating log likelihood in Condition Stage
#'
#' Function written in \code{C++} estimating the log likelihood of a given
#' parameter set during the condition stage.
#'
#' @param observations \code{NumericVector} containing the frequency of the
#' categories.
#' @param anchor \code{Integer} ranging between 1 and the number of categories.
#' Anchor defines the reference category. That is the category with the highest
#' probability according to the assumption of weak superiority.
#' @param max_iter \code{Integer} specifying the maximal number of iterations
#' for each random start.
#' @param n_random_starts \code{Integer} for the number of random start.
#' @param step_size \code{Double} for specifying the size for increasing or
#' decreasing the probabilities during the estimation. This value should not
#' be less than 1e-3.
#' @param cr_rel_change \code{Double} for defining when the estimation should
#' stop. That is, if the change in log-likelihood is smaller as this value the
#' estimation stops.
#' @param fast \code{Bool} If \code{TRUE} a fast estimation is applied. This
#' option ignored all other parameters. If
#' \code{FALSE} the estimation described in Berding and Pargmann (2022) is used.
#' Default is \code{TRUE}.
#' @param trace \code{Bool} \code{TRUE} if information about the progress of
#' estimation should be printed to the console. \code{FALSE} if not desired.
#' @return Returns the log likelihood as a single numeric value.
#' @importFrom Rcpp sourceCpp
#' @useDynLib iotarelr
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
#' @export
est_con_multinominal_c <- function(observations, anchor, max_iter = 500000L, step_size = 1e-4, cr_rel_change = 1e-12, n_random_starts = 10L, fast = TRUE, trace = FALSE) {
    .Call('_iotarelr_est_con_multinominal_c', PACKAGE = 'iotarelr', observations, anchor, max_iter, step_size, cr_rel_change, n_random_starts, fast, trace)
}

#'Check assumptions of weak superiority
#'
#'This function tests if the probabilities within the Assignment Error Matrix
#'are in line with the assumption of weak superiority.
#'
#'@param aem matrix of probabilities
#'@return Returns the number of violations of the assumption of weak superiority.
#'0 if the assumptions are fulfilled.
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
#'@export
check_conformity_c <- function(aem) {
    .Call('_iotarelr_check_conformity_c', PACKAGE = 'iotarelr', aem)
}

#'Parameter estimation via EM Algorithm with Condition Stage
#'
#'Function written in \code{C++} for estimating the parameters of the model
#'via Expectation Maximization (EM Algorithm).
#'
#' @param obs_pattern_shape \code{Matrix} containing the unique patterns found
#' in the data. Ideally this matrix is generated by the function
#' \code{get_patterns()}.
#' @param obs_pattern_frq \code{Vector} containing the frequencies of the
#' patterns. Ideally it is generated by the the function
#' \code{get_patterns()}.
#' @param obs_internal_count \code{Matrix} containing the relative frequencies
#' of each category within each pattern. Ideally this matrix is generated by
#' the function \code{get_patterns()}.
#' @param categorical_levels \code{Vector} containing all possible categories of
#' the content analysis.
#'@param random_starts \code{Integer} for determining how often the algorithm
#'should restart with randomly chosen values for the Assignment Error Matrix
#'and the categorical sizes.
#'@param max_iterations \code{Integer} for determining the maximum number of iterations
#'for each random start.
#'@param rel_convergence \code{Double} for determining the convergence criterion. The
#'algorithm stops if the relative change is smaller than this criterion.
#' @param con_step_size \code{Double} for specifying the size for increasing or
#' decreasing the probabilities during the condition stage of estimation.
#' This value should not be less than 1e-3.
#' @param con_random_starts \code{Integer} for the number of random starts
#' within the condition stage.
#' @param con_max_iterations \code{Integer} for the maximum number of iterations
#' during the condition stage.
#' @param con_rel_convergence \code{Double} for determining the convergence
#' criterion during condition stage. The algorithm stops if the relative change
#' is smaller than this criterion.
#' @param fast \code{Bool} If \code{TRUE} a fast estimation is applied during the
#' condition stage. This option ignores all parameters beginning with "con_".
#' If \code{FALSE} the estimation described in Berding and
#' Pargmann (2022) is used. Default is \code{TRUE}.
#'@param trace \code{TRUE} for printing progress information on the console.
#'\code{FALSE} if this information should not be printed.
#'@param con_trace \code{TRUE} for printing progress information on the console
#'during estimations in the condition stage. \code{FALSE} if this information
#'should not be printed.
#'@return Function returns a \code{list} with the estimated parameter sets for
#'every random start. Every parameter set contains the following components:
#'\item{log_likelihood}{Log likelihood of the estimated solution.}
#'\item{aem}{Estimated Assignment Error Matrix (aem). The rows represent the
#'true categories while the columns stand for the assigned categories. The cells
#'describe the probability that a coding unit of category i is assigned to
#'category j.}
#'\item{categorial_sizes}{\code{Vector} of estimated sizes for each
#'category.}
#'\item{convergence}{If the algorithm converged within the iteration limit
#'\code{TRUE}. \code{FALSE} in every other case.}
#'\item{iteration}{Number of iterations when the algorithm was terminated.}
#'@export
#'@importFrom Rcpp sourceCpp
#'@useDynLib iotarelr
#'@references  Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
#'of the Second Generation.Measures for Content Analysis Done by
#'Humans or Artificial Intelligences. Berlin: Logos.
#'https://doi.org/10.30819/5581
EM_algo_c <- function(obs_pattern_shape, obs_pattern_frq, obs_internal_count, categorical_levels, random_starts, max_iterations, rel_convergence, con_step_size, con_random_starts, con_max_iterations, con_rel_convergence, fast, trace, con_trace) {
    .Call('_iotarelr_EM_algo_c', PACKAGE = 'iotarelr', obs_pattern_shape, obs_pattern_frq, obs_internal_count, categorical_levels, random_starts, max_iterations, rel_convergence, con_step_size, con_random_starts, con_max_iterations, con_rel_convergence, fast, trace, con_trace)
}

