% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_functions.R
\name{check_new_rater}
\alias{check_new_rater}
\title{Check new rater}
\usage{
check_new_rater(
  true_values,
  assigned_values,
  con_step_size = 1e-04,
  con_random_starts = 5,
  con_max_iterations = 5000,
  con_rel_convergence = 1e-12,
  con_trace = FALSE,
  fast = TRUE
)
}
\arguments{
\item{true_values}{\code{Vector} containing the true categories of the coding
units. Vector must have the same length as \code{assigned_values}.}

\item{assigned_values}{\code{Vector} containing the assigned
categories of the coding units. Missing values are currently not supported and
have to be omitted from the vector. Vector must have the same length as
\code{true_values}.}

\item{con_step_size}{\code{Double} for specifying the size for increasing or
decreasing the probabilities during the conditioning stage of estimation.
This value should not be less than 1e-3.}

\item{con_random_starts}{\code{Integer} for the number of random starts
within the condition stage.}

\item{con_max_iterations}{\code{Integer} for the maximum number of iterations
during the conditioning stage.}

\item{con_rel_convergence}{\code{Double} for determining the convergence
criterion during the conditioning stage. The algorithm stops if the relative change
is smaller than this criterion.}

\item{con_trace}{\code{TRUE} for printing progress information on the console
during estimations in the conditioning stage. \code{FALSE} if you do not want to have
this information printed.}

\item{fast}{\code{Bool} If \code{TRUE} a fast estimation is applied during the
condition stage. This option ignores all parameters beginning with "con_".
If \code{FALSE} the estimation described in Berding and
Pargmann (2022) is used. Default is \code{TRUE}.}
}
\value{
Returns a \code{list} with the following three components:
The first component \code{estimates_categorical_level} comprises all
elements that describe the ratings on a categorical level. The elements are
sub-divided into raw estimates and chance-corrected estimates.
\describe{
\item{\code{raw_estimates}}{
\itemize{
\item{\code{alpha_reliability: }}{A vector containing the Alpha
Reliabilities for each category. These values represent probabilities.}
\item{\code{beta_reliability: }}{A vector containing the Beta Reliabilities for each
category. These values represent probabilities.}
\item{\code{assignment_error_matrix: }}{An Assignment Error Matrix containing the conditional
probabilities for assigning a unit of category i to categories 1 to n.}
#' \item{\code{iota: }}
{A vector containing the Iota values for each category.}
}}
\item{\code{elements_chance_corrected}}{
\itemize{
\item{\code{alpha_reliability: }}
{A vector containing the chance-corrected Alpha Reliabilities for each category.}
\item{\code{beta_reliability: }}
{A vector containing the chance-corrected Beta Reliabilities for each category.}
}}
}
The second component \code{estimates_scale_level} contains elements to
describe the quality of the ratings on a scale level. It contains the
following elements:
\itemize{
\item{\code{iota_index: }}
{The Iota Index representing the reliability on a scale level.}
\item{\code{iota_index_d4: }}
{The Static Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
\item{\code{iota_index_dyn2: }}
{The Dynamic Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
}
The third component \code{information} contains important information
regarding the parameter estimation. It comprises the following elements:
\itemize{
\item{\code{log_likelihood: }}
{Log-likelihood of the best solution.}
\item{\code{convergence: }}
{If estimation converged 0, otherwise 1.}
\item{\code{est_true_cat_sizes: }}
{Estimated categorical sizes. This is the estimated amount of the categories.}
\item{\code{conformity: }}
{\code{0} if the solution is in line with assumptions of weak superiority.
 A number greater 0 indicates the number of violations of the assumption
 of weak superiority.}
 \item{\code{random_starts: }}
{Numer of random starts for the EM algorithm.}
\item{\code{boundaries: }}
{\code{False} if the best solution does not contain boundary values.
\code{True} if the best solution does contain boundary values}
\item{\code{p_boundaries: }}
{Percentage of solutions with boundary values during estimation.}
\item{\code{call: }}
{Name of the function that created the object.}
\item{\code{n_rater: }}
{Number of raters.}
\item{\code{n_cunits: }}
{Number of coding units.}
}
}
\description{
Function for estimating the reliability of codings for a new rater based on
Iota 2
}
\note{
The returned object contains further slots since the returned object is
of class \code{iotarelr_iota2}. These slots are empty because they are not part of the
estimation within this function.
}
\references{
Florian Berding and Julia Pargmann (2022).Iota Reliability Concept
of the Second Generation. Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
