% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_size.R
\name{network_size}
\alias{network_size}
\alias{network_address}
\alias{broadcast_address}
\alias{num_addresses}
\title{Network size}
\usage{
network_address(x)

broadcast_address(x)

num_addresses(x)
}
\arguments{
\item{x}{An \code{\link{ip_network}} vector}
}
\value{
\itemize{
\item \code{network_address()}: An \code{\link{ip_address}} vector
\item \code{broadcast_address()}: An \code{\link{ip_address}} vector
\item \code{num_addresses()}: A numeric vector
}
}
\description{
\code{network_address()} and \code{broadcast_address()} yield the first and last
addresses of the network; \code{num_addresses()} gives the total number of
addresses in the network.
}
\details{
The broadcast address is a special address at which any host connected
to the network can receive messages. That is, packets sent to this address
are received by all hosts on the network.
In IPv4, the last address of a network is the broadcast address.
Although IPv6 does not follow this approach to broadcast addresses, the
\code{broadcast_address()} function still returns the last address of the network.
}
\examples{
x <- ip_network(c("192.168.0.0/22", "2001:db8::/33"))

network_address(x)

broadcast_address(x)

num_addresses(x)
}
\seealso{
Use \code{\link[=seq.ip_network]{seq.ip_network()}} to generate all addresses in a network.
}
