% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timesToKeep.R
\name{timesTokeep}
\alias{timesTokeep}
\title{Function to keep all event times}
\usage{
timesTokeep(data, id, tstart, tstop, mes.cov, time.cov)
}
\arguments{
\item{data}{dataframe containing the following variables}

\item{id}{patient's id}

\item{tstart}{date of the beginning of the follow-up (in Date format)}

\item{tstop}{date of the end of the follow-up (in Date format)}

\item{mes.cov}{list of vectors, each of them must contain the names (in character format)
of the repeated measurements related to one time-dependent covariate}

\item{time.cov}{list of vectors, each of them must contain the times (in Date format)
of the date when the abovementioned measurements were done}
}
\value{
list of two lists, one in Date format the other in numeric format.
Each of them contains, for each patient, the event time and
the times of changes in time-varying covariates
}
\description{
Function to keep all event times
}
\examples{
kept.t <- timesTokeep(toydata, id = "id",
tstart = "randt", tstop = "lastdt",
mes.cov = list(c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")))
# For example, for patient id=3, to obtain the kept times in Date format:
kept.t[[1]][[3]]
# To obtain the kept times in numeric format:
kept.t[[2]][[3]]
}
\references{
Graffeo, N., Latouche, A., Le Tourneau C., Chevret, S. "An R Package for IPCW: Application to switches in clinical trials" \emph{(submitted)}
}
\seealso{
\code{\link{data.ipcw}}
}
