% Generated by roxygen2 (4.0.1): do not edit by hand
\name{costrasterGen}
\alias{costrasterGen}
\title{Generate a cost Raster}
\usage{
costrasterGen(xymat, pols, extent = "polys", projstr)
}
\arguments{
  \item{xymat}{Matrix of coordinates}

  \item{pols}{SpatialPolygons object}

  \item{extent}{Define extent based on extent of xymat
  (pnts) or pols (polys). Default is polys.}

  \item{projstr}{proj4 string defining the inherent
  projection}
}
\value{
RasterLayer
}
\description{
generate a cost raster from an object of class
"SpatialPolygons"
}
\examples{
Sr1<-Polygon(cbind(c(0,0,2,2,0),c(0,4,4,0,0)))
Sr2<-Polygon(cbind(c(2,2,4,4,2),c(0,2,2,0,0)))
Srs1<-Polygons(list(Sr1), "s1")
Srs2<-Polygons(list(Sr2), "s2")
pols<-SpatialPolygons(list(Srs1,Srs2), 1:2)

xymat<-matrix(3,3,nrow=1,ncol=2)
costras<-costrasterGen(xymat,pols,projstr=NULL)
plot(costras)
points(xymat)
}
\author{
Joseph Stachelek
}

