/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class MsgDialog
extends Dialog
implements ActionListener {
    public String lastResult;
    public static final String[] okCancel = new String[]{"OK", "Cancel"};
    public static final String[] yesNoCancel = new String[]{"Yes", "No", "Cancel"};
    public static final String[] yesNo = new String[]{"Yes", "No"};

    public MsgDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, null);
    }

    public MsgDialog(Frame frame, String string, String string2, String[] stringArray) {
        super(frame, true);
        this.setLayout(new BorderLayout());
        this.setTitle(string);
        this.add(new ZLabel(string2));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        if (stringArray == null || stringArray.length == 0) {
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(this);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                Button button = new Button(stringArray[n++]);
                panel.add(button);
                button.addActionListener(this);
            }
        }
        this.add((Component)panel, "South");
        this.add((Component)new SpacingPanel(), "West");
        this.add((Component)new SpacingPanel(), "East");
        this.add((Component)new SpacingPanel(50, 10), "North");
        this.pack();
        this.setResizable(false);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.lastResult = actionEvent.getActionCommand();
        this.dispose();
    }

    public class ZLabel
    extends Canvas {
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;
        protected String[] lines;
        protected int numLines;
        protected int marginWidth;
        protected int marginHeight;
        protected int lineHeight;
        protected int lineAscent;
        protected int maxWidth;
        protected int alignment = 0;
        protected int[] lineWidths;

        protected void newLabel(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            this.numLines = stringTokenizer.countTokens();
            this.lines = new String[this.numLines];
            this.lineWidths = new int[this.numLines];
            for (int i = 0; i < this.numLines; ++i) {
                this.lines[i] = stringTokenizer.nextToken();
            }
        }

        protected void measure() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                return;
            }
            this.lineHeight = fontMetrics.getHeight();
            this.lineAscent = fontMetrics.getAscent();
            this.maxWidth = 0;
            for (int i = 0; i < this.numLines; ++i) {
                this.lineWidths[i] = fontMetrics.stringWidth(this.lines[i]);
                if (this.lineWidths[i] <= this.maxWidth) continue;
                this.maxWidth = this.lineWidths[i];
            }
        }

        public ZLabel(String string, int n, int n2, int n3) {
            this.newLabel(string);
            this.marginWidth = n;
            this.marginHeight = n2;
            this.alignment = n3;
        }

        public ZLabel(String string, int n, int n2) {
            this(string, n, n2, 0);
        }

        public ZLabel(String string, int n) {
            this(string, 10, 10, n);
        }

        public ZLabel(String string) {
            this(string, 10, 10, 0);
        }

        public void setLabel(String string) {
            this.newLabel(string);
            this.measure();
            this.repaint();
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.measure();
            this.repaint();
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.repaint();
        }

        public void setAlignment(int n) {
            this.alignment = n;
            this.repaint();
        }

        public void setMarginWidth(int n) {
            this.marginWidth = n;
            this.repaint();
        }

        public void setMarginHeight(int n) {
            this.marginHeight = n;
            this.repaint();
        }

        public int getAlignment() {
            return this.alignment;
        }

        public int getMarginWidth() {
            return this.marginWidth;
        }

        public int getMarginHeight() {
            return this.marginHeight;
        }

        public void addNotify() {
            super.addNotify();
            this.measure();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.maxWidth + 2 * this.marginWidth, this.numLines * this.lineHeight + 2 * this.marginHeight);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.maxWidth, this.numLines * this.lineHeight);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = this.lineAscent + (dimension.height - this.numLines * this.lineHeight) / 2;
            int n2 = 0;
            while (n2 < this.numLines) {
                int n3;
                switch (this.alignment) {
                    case 0: {
                        n3 = this.marginWidth;
                        break;
                    }
                    case 2: {
                        n3 = dimension.width - this.marginWidth - this.lineWidths[n2];
                        break;
                    }
                    default: {
                        n3 = (dimension.width - this.lineWidths[n2]) / 2;
                    }
                }
                graphics.drawString(this.lines[n2], n3, n);
                ++n2;
                n += this.lineHeight;
            }
        }
    }

    public class SpacingPanel
    extends Panel {
        int spacex;
        int spacey;

        SpacingPanel() {
            this.spacey = 15;
            this.spacex = 15;
        }

        SpacingPanel(int n) {
            this.spacex = this.spacey = n;
        }

        SpacingPanel(int n, int n2) {
            this.spacex = n;
            this.spacey = n2;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.spacex, this.spacey);
        }

        public Dimension getMaximumSize() {
            return new Dimension(this.spacex, this.spacey);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.spacex, this.spacey);
        }
    }
}

