% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xff_extract}
\alias{xff_extract}
\title{Take vectors of IPs and X-Forwarded-For headers and produce single, normalised
IP addresses.}
\usage{
xff_extract(ip_addresses, x_forwarded_for)
}
\arguments{
\item{ip_addresses}{a vector of IP addresses}

\item{x_forwarded_for}{an equally-sized vector of X-Forwarded-For header
contents.}
}
\value{
a vector of IP addresses, incorporating the XFF header value
where appropriate.
}
\description{
\code{xff_extract} takes IP addresses and x_forwarded_for
values and, in the event that x_forwarded_for is non-null, attempts to
extract the "real" IP closest to the client.
}
\examples{
xff_extract("192.168.0.1", "193.168.0.1, 230.98.107.1")

}
