% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip-to-subnet.R
\name{ip_to_subnet}
\alias{ip_to_subnet}
\title{Create an IPv4 network from an address and prefix length.}
\usage{
ip_to_subnet(ip_addresses, prefix_lengths = NULL)
}
\arguments{
\item{ip_addresses}{either a character vector of IP addresses in CIDR notation
(e.g. \verb{1.2.3.4/24}) --- in which case \code{prefix_lengths} should be \code{NULL} ---
or a character vector of IP addresses --- in which case \code{prefix_lengths} should
be a character vector of the same length as \code{ip_addresses}.}

\item{prefix_lengths}{should be \code{NULL} (the default) if \code{ip_addresses} is a
a character vector of IP addresses in CIDR notation otherwise should be
a character vector of the same length as \code{ip_addresses}.}
}
\description{
Given a character vector of IP addresses in CIDR notation (e.g. \verb{1.2.3.4/24})
or a character vector of IP addresses and an integer vector of prefix lengths,
return a character vector of the network (in CIDR notation).
}
\details{
Suggested by Slava Nikitin (\url{https://github.com/hrbrmstr/iptools/issues/38}).
}
\examples{
host_ip <- c("1.2.3.4", "4.3.2.1")
subnet_len <- c(24L, 25L)
ip_to_subnet(host_ip, subnet_len)
ip_to_subnet(c("1.2.3.4/24", "4.3.2.1/25"))
}
