% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{extract_list_to_tbl}
\alias{extract_list_to_tbl}
\title{Convert a list of extract definitions to a tibble}
\usage{
extract_list_to_tbl(extract_list)
}
\arguments{
\item{extract_list}{A list of \code{\link[=ipums_extract-class]{ipums_extract}} objects.}
}
\value{
A \code{\link[tibble:tbl_df-class]{tibble}} with number of rows equal to the
length of \code{extract_list}, in which each row contains the definition
of one extract.
}
\description{
Convert a list of \code{\link[=ipums_extract-class]{ipums_extract}} objects to a
\code{\link[tibble:tbl_df-class]{tibble}} in which each row contains the definition of
one extract. For an overview of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
\dontrun{
# Get list of recent extracts
list_of_last_10_extracts <- get_recent_extracts_info_list("usa")

# Print the extract number for extracts that are downloadable:
for (extract in list_of_last_10_extracts) {
  if (is_extract_ready(extract)) print(extract$number)
}

# Convert list of extracts to tibble of extracts to view in a tabular format
extract_list_to_tbl(list_of_last_10_extracts)
}

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
