% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_metadata.R
\name{get_sample_info}
\alias{get_sample_info}
\title{List available samples for IPUMS microdata collections}
\usage{
get_sample_info(
  collection = NULL,
  delay = 0,
  api_key = Sys.getenv("IPUMS_API_KEY")
)
}
\arguments{
\item{collection}{Character string of the IPUMS collection for which to
retrieve sample IDs. Defaults to the current default collection,
if it exists. See \code{\link[=set_ipums_default_collection]{set_ipums_default_collection()}}.

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{delay}{Number of seconds to delay between
successive API requests, if multiple requests are needed to retrieve all
records.

A delay is highly unlikely to be necessary and is intended only as a
fallback in the event that you cannot retrieve all sample IDs without
exceeding the API rate limit.}

\item{api_key}{API key associated with your user account. Defaults to the
value of the \code{IPUMS_API_KEY} environment variable. See
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}}.}
}
\value{
A \code{\link[tibble:tbl_df-class]{tibble}} containing sample IDs and
descriptions for the indicated collection.
}
\description{
Retrieve sample IDs and descriptions for IPUMS microdata collections.

Currently supported microdata collections are:
\itemize{
\item IPUMS USA (\code{"usa"})
\item IPUMS CPS (\code{"cps"})
\item IPUMS International (\code{"ipumsi"})
}

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
\dontrun{
get_sample_info("usa")
get_sample_info("cps")
get_sample_info("ipumsi")
}
}
\seealso{
\code{\link[=define_extract-micro]{define_extract_*()}} to create an IPUMS microdata
extract definition.
}
\keyword{internal}
