% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_process_extract.R
\name{submit_extract}
\alias{submit_extract}
\title{Submit an extract request via the IPUMS API}
\usage{
submit_extract(extract, api_key = Sys.getenv("IPUMS_API_KEY"))
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{api_key}{API key associated with your user account. Defaults to the
value of the \code{IPUMS_API_KEY} environment variable. See
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}}.}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object containing the
extract definition and newly-assigned extract number of the submitted
extract.

Note that some unspecified extract fields may be populated with default
values and therefore change slightly upon submission.
}
\description{
Submit an extract request via the IPUMS API and return an
\code{\link[=ipums_extract-class]{ipums_extract}} object containing the extract
definition with a newly-assigned extract request number.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
my_extract <- define_extract_micro(
  collection = "cps",
  description = "2018-2019 CPS Data",
  samples = c("cps2018_05s", "cps2019_05s"),
  variables = c("SEX", "AGE", "YEAR")
)

\dontrun{
# Store your submitted extract request to obtain the extract number
submitted_extract <- submit_extract(my_extract)

submitted_extract$number

# This is useful for checking the extract request status
get_extract_info(submitted_extract)

# You can always get the latest status, even if you forget to store the
# submitted extract request object
submitted_extract <- get_last_extract_info("cps")

# You can also check if submitted extract is ready
is_extract_ready(submitted_extract)

# Or have R check periodically and download when ready
downloadable_extract <- wait_for_extract(submitted_extract)
}
}
\seealso{
\code{\link[=wait_for_extract]{wait_for_extract()}} to wait for an extract to finish processing.

\code{\link[=get_extract_info]{get_extract_info()}} and \code{\link[=is_extract_ready]{is_extract_ready()}} to check the status of an
extract request.

\code{\link[=download_extract]{download_extract()}} to download an extract's data files.
}
