% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterAnalysis.R
\name{get_instanceID_seed_pairs}
\alias{get_instanceID_seed_pairs}
\title{Returns the pairs of instance IDs and seeds used as instances in the race
(and optionally the actual instances).}
\usage{
get_instanceID_seed_pairs(iraceResults, index, instances = FALSE)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}

\item{index}{(\code{integer()})\cr Indexes of the (instanceID,seed) pairs to be returned. The default returns everything.}

\item{instances}{(\code{logical(1)})\cr Whether to add the actual instances as an additional column (only if the instances are of atomic type).}
}
\value{
\code{data.table()}\cr With default arguments, a \code{data.table} containing two columns
\code{"instanceID"} and \code{"seed"}. With \code{instances=TRUE} and if the instances
are of atomic type (see \code{\link[=is.atomic]{is.atomic()}}) type, another column \code{instance} is
added that contains the actual instance.
}
\description{
Returns the pairs of instance IDs and seeds used as instances in the race
(and optionally the actual instances).
}
\examples{
log_file <- system.file("exdata/irace-acotsp.Rdata", package="irace", mustWork=TRUE)
head(get_instanceID_seed_pairs(log_file))
# Add the instance names
get_instanceID_seed_pairs(log_file, index=1:10, instances=TRUE)
}
\author{
Manuel López-Ibáñez
}
\concept{analysis}
