% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ar1_sim_irregular}
\alias{ar1_sim_irregular}
\title{Simulate from a stationary Gaussian AR(1) process at irregular times.}
\usage{
ar1_sim_irregular(times, rho, sigma, mu = 0)
}
\arguments{
\item{times}{The time points to simulate for.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}

\item{mu}{A vector of expected values with length \code{length(times)}, or a
scalar (default equal to 0).}
}
\value{
A vector of length \code{n} with the process values.
}
\description{
Simulate from a stationary Gaussian AR(1) process at irregular times.
}
\examples{
times <- c(3, 5:7, 10)
rho <- 0.5
sigma <- 1
mu <- seq_along(times)
ar1_sim_irregular(times, rho, sigma)
ar1_sim_irregular(times, rho, sigma, mu)
}
