% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot_resp_loglik}
\alias{plot_resp_loglik}
\title{Plot the Log-Likelihood of a response string}
\usage{
plot_resp_loglik(
  ip,
  resp,
  theta_range = c(-5, 5),
  title = "",
  likelihood = FALSE,
  show_estimate = TRUE,
  suppress_plot = FALSE,
  text_size = 12,
  ...
)
}
\arguments{
\item{ip}{An \code{\link{Itempool-class}} class object.}

\item{resp}{The response string}

\item{theta_range}{The boundaries of x axis.}

\item{title}{Title of the Plot}

\item{likelihood}{If \code{TRUE}, likelihood function will be plotted
instead of log-likelihood graph. Default value is \code{FALSE}.}

\item{show_estimate}{If \code{TRUE} the maximum likelihood ability estimate
will be shown. The default value is \code{TRUE}.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{text_size}{The overall text size of the axis and titles. The default
value is 12.}

\item{...}{Additional arguments passed to annotate.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the Log-likelihood function of the response string or returns the plot
object.
}
\description{
\code{plot_resp_loglik} plots the log-likelihood of a response string.
}
\section{To-do}{

\itemize{
\item Make it to plot multiple test information functions. You can input a
list each of which contains item parameters. And the name of the test also.
}
}

\examples{
n <- sample(10:50,1)
ip <- itempool(data.frame(a = runif(n, .5, 2), b = rnorm(n),
                             c = runif(n, 0, .3), D = 1.7))
resp <- sim_resp(ip = ip, theta = rnorm(1))
plot_resp_loglik(ip, resp)
plot_resp_loglik(ip, resp, text_size = 9)
# Format the text of the MLE estimate
plot_resp_loglik(ip, resp, size = 3, color = 'blue')
# Suppress the MLE estimate
plot_resp_loglik(ip, resp, show_estimate = FALSE)
}
\author{
Emre Gonulates
}
