% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_analysis.R
\name{distractor_analysis}
\alias{distractor_analysis}
\title{Distractor Analysis Function}
\usage{
distractor_analysis(
  raw_resp,
  key,
  criterion = NULL,
  adjusted = FALSE,
  suppress_output = FALSE
)
}
\arguments{
\item{raw_resp}{A \code{matrix} or \code{data.frame} containing the item
responses.}

\item{key}{The answer key for the responses}

\item{criterion}{Provide a continuous criterion variable such as a total
raw score, or theta score that will be used in the calculation of
correlation calculations. If this value is \code{NULL}, the total score
will be used.}

\item{adjusted}{If \code{TRUE}, the biserial will be calculated using the
total score that is calculated using all of the items except the item
that biserial is calculated for.}

\item{suppress_output}{If \code{TRUE}, the function will suppress
console output. Default value is \code{FALSE}}
}
\value{
A list of
  \describe{
    \item{'prop'}{Observed proportions of each choice.}
    \item{'biserial'}{Biserial correlation between the examinees selected
          the choice and the total scores.}
    \item{'score'}{Scored response matrix.}
  }
}
\description{
Distractor Analysis Function
}
\examples{
n_item <- 10 # sample(8:12, 1)
n_theta <- 50 # sample(100:200, 1)
raw_resp <- matrix(sample(LETTERS[1:4], n_item * n_theta, replace = TRUE),
                   nrow = n_theta, ncol = n_item,
                   dimnames = list(paste0("Examinee-", 1:n_theta),
                                   paste0("Item-", 1:n_item)))
# Add some missing responses
raw_resp[sample(1:length(raw_resp), round(length(raw_resp)*.1))] <- NA
# Prepare answer key
key <- sample(LETTERS[1:4], n_item, replace = TRUE)

# Run distractor analysis:
da <- distractor_analysis(raw_resp = raw_resp, key = key)

}
\author{
Emre Gonulates
}
