% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Testlet-class-methods.R
\name{testlet}
\alias{testlet}
\title{Creates a \code{\link{Testlet-class}} object}
\usage{
testlet(...)
}
\arguments{
\item{...}{The object that is desired to be converted to a \code{Testlet}
object. Also additional arguments related to the \code{Testlet}.}
}
\value{
An \code{\link{Testlet-class}} object.
}
\description{
Create a \code{\link{Testlet-class}} object. It is recommended
  to use this function to create new \code{\link{Testlet-class}} objects.
}
\examples{
ip <- itempool(a = c(1, 1.4), b = c(-2, 1))
testlet(ip, id = "T1")
testlet(ip, id = "T1", content = "Algebra")
# Add misc field to the testlet:
testlet(ip, id = "T1", misc = list(form = "A1", operational = TRUE,
                                   admin_date = as.Date("2020-08-01")))

# Add misc field to the testlet items:
testlet(itempool(b = rnorm(2), id = paste0("t1-i", 1:2),
                 misc = list(list(sympson_hetter_k = .8, form = "B1"),
                             list(sympson_hetter_k = .9))),
        id = "t1")
}
\author{
Emre Gonulates
}
