% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_set-class-methods.R
\name{as.matrix,Response_set-method}
\alias{as.matrix,Response_set-method}
\title{Convert a \code{\link{Response_set-class}} object into a \code{matrix}}
\usage{
\S4method{as.matrix}{Response_set}(x, ..., output = "score", ip = NULL)
}
\arguments{
\item{x}{A \code{\link{Response_set-class}} object}

\item{...}{additional arguments}

\item{output}{Contents of the matrix. The default value is \code{"score"}.
Other options are:
\describe{
  \item{"score"}{Matrix of item scores. }
  \item{"raw_response"}{Matrix of raw responses.}
  \item{"item_id"}{Matrix of item ids.}
  \item{"testlet_id"}{Matrix of testlet ids.}
  \item{"response_time"}{Matrix of response times.}
  \item{"order"}{Matrix of item orders.}
  \item{misc}{If all responses has the same \code{'misc'} field, then
    the matrix of that misc field can be extracted.}
}}

\item{ip}{An \code{\link{Itempool-class}} object to use for adding item_id's
as column names. If there are items that are in the item pool but not in
the response data, those items will be added and all values will be
\code{NA}.}
}
\value{
A matrix of examinee item scores within each row and items in each
  column.
}
\description{
This function converts \code{\link{Response_set-class}} objects
  to a \code{matrix} object.
}
\examples{
ip <- generate_ip(n = 15)
resp_set <- generate_resp_set(ip = ip, theta = rnorm(30), prop_missing = .5)
# Matrix of item scores
as.matrix(resp_set)

# If the item pool object provided, the column names will have the same
# order as the item order in item pool
as.matrix(resp_set, ip = ip)

# Matrix of raw responses
as.matrix(resp_set, output = "raw_response")

# Matrix of item order
as.matrix(resp_set, output = "order")

# Matrix of item ids
as.matrix(resp_set, output = "item_id")


}
\author{
Emre Gonulates
}
