% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{$.cat_output}
\alias{$.cat_output}
\title{Prints the raw output of cat_sim}
\usage{
\method{$}{cat_output}(x, name)
}
\arguments{
\item{x}{This is a cat_output object which has \code{"cat_output"} class.}

\item{name}{Name of the field.
Available options:
\describe{
  \item{\strong{\code{"ip"}}}{Extract items administered to examinee}
  \item{\strong{\code{"resp"}}}{Extract responses}
  \item{\strong{\code{"testlet"}}}{Extract testlets administered}
  \item{\strong{\code{"est_before"}}}{Extract ability estimate
    before administration of an item.}
  \item{\strong{\code{"item_id"}}}{Extract administered item IDs.}
  \item{\strong{\code{"est_after"}}}{Extract ability estimate
    after administration of an item.}
  \item{\strong{\code{"se_before"}}}{Extract standard error
    before administration of an item.}
  \item{\strong{\code{"se_after"}}}{Extract standard error
    after administration of an item.}
  \item{\strong{\code{"true_theta"}}}{Extract true theta as a vector}
  \item{\strong{\code{"test_length"}}}{Extract test length of the adaptive
    test}
  \item{\strong{\code{"final_est"}}}{Extract final ability estimate.}
  \item{\strong{\code{"final_se"}}}{Extract final standard error.}
  }}
}
\value{
See the 'name' argument above for possible return values.
}
\description{
This function prints a data frame that shows all of the steps of
  a CAT for a single examinee.
}
\examples{
n <- 20 # number of items
ip <- generate_ip(n = n)
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
cat_data <- cat_sim(true_ability = rnorm(1), cd = cd)
cat_data
cat_data$resp # Extract responses to administered items
cat_data$ip # Administered items
cat_data$item_id # Extract administered item IDs
cat_data$est_before # Ability estimates before the administration of an item
cat_data$est_after # Ability estimates after the administration of an item
cat_data$true_theta # True ability that generates examinee responses

# Simulation with more than one simulees
n <- 20 # number of items
ip <- generate_ip(n = n)
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
n_examinee <- 3
cat_data_list <- cat_sim(true_ability = rnorm(n_examinee), cd = cd)
cat_data_list[[3]]$item_id
cat_data_list[[2]]$item_id
cat_data_list[[3]]$resp
cat_data_list[[2]]$resp
cat_data_list[[2]]$test_length
cat_data_list[[2]]$final_est
cat_data_list[[2]]$final_se
}
\seealso{
\code{\link{cat_sim}}
}
\author{
Emre Gonulates
}
