% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IrregularSamplingTimes.R
\name{irregular_single_dataset}
\alias{irregular_single_dataset}
\title{c/e rates for irregular samplings in a dataset}
\usage{
irregular_single_dataset(dataframe, vector, c, e, column = NULL, n = NULL,
  int = NULL, assembly = F)
}
\arguments{
\item{dataframe}{A single dataframe.}

\item{vector}{A vector indicating the columns with presence-absence data.}

\item{c}{Tentative colonization rate.}

\item{e}{Tentative extinction rate.}

\item{column}{The name of the column with groups to calculate their c_e pair.}

\item{n}{Minimal number of rows for each group}

\item{int}{Accuracy to calculate the c_e pairs with.}

\item{assembly}{Logical indicating if the assembly starts from zero species or not.}
}
\value{
A dataframe with colonization and extinction rates and their upper
  and lower confidence interval, and if needed, the names of the groups to
  which colonization and extinction rates have been calculated.
}
\description{
\code{irregular_single_dataset} calculates colonization and extinction rates
in a single dataset.
}
\note{
The columns with the presence-absence data should have the day of that
  sampling on the name of the column in order to calculate colonization and
  extinction.
}
\examples{
irregular_single_dataset(simberloff[[1]], 3:17, 0.001, 0.001)
irregular_single_dataset(simberloff[[1]], 3:17, column = "Tax. Unit 1",
0.001, 0.001, 3)
\dontrun{
irregular_single_dataset(simberloff[[1]], 3:17, column = "Tax. Unit 1",
0.001, 0.001, 3, 0.000001)
}
}
\seealso{
\code{\link{regular_sampling_scheme}},
  \code{\link{irregular_multiple_datasets}}
}

