% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IrregularSamplingTimes.R
\name{irregular_single_dataset}
\alias{irregular_single_dataset}
\alias{NLL_isd}
\title{c/e rates for irregular samplings in a dataset}
\usage{
irregular_single_dataset(
  dataframe,
  vector,
  c,
  e,
  column = NULL,
  n = NULL,
  step = NULL,
  assembly = FALSE,
  jacobian = FALSE,
  verbose = FALSE,
  CI = FALSE
)

NLL_isd(dataframe, vector, c, e, assembly = FALSE)
}
\arguments{
\item{dataframe}{A single dataframe.}

\item{vector}{A vector indicating the columns with presence-absence data.}

\item{c}{Tentative colonization rate.}

\item{e}{Tentative extinction rate.}

\item{column}{The name of the column with groups to calculate their c_e pair.}

\item{n}{Minimal number of rows for each group}

\item{step}{Accuracy to calculate the c_e pairs with.}

\item{assembly}{Logical indicating if the assembly starts from zero species
or not.}

\item{jacobian}{Logical. Use the semianalytical method to estimate colonization
and extinction rates?}

\item{verbose}{Logical. If TRUE, gives the output of the optimizer or the
numerical solver that finds the values of c and e.}

\item{CI}{Logical. If TRUE, gives the confidence interval of the colonization
and extinction rates.}
}
\value{
\code{irregular_single_dataset} returns a dataframe with colonization
  and extinction rates and their upper and lower confidence interval, and if
  needed, the names of the groups to which colonization and extinction rates
  have been calculated. \code{NLL_isd} gives the NLL for a single dataset in
  an irregular sampling scheme given a specific c and e.
}
\description{
\code{irregular_single_dataset} estimates colonization and extinction rates
in a single dataset with irregular sampling scheme. \cr \code{NLL_isd} returns
the Negative Log-Likelihood of a pair of colonization and extinction rates
for an irregular sampling scheme in a single dataset.
}
\note{
The columns with the presence-absence data should have the day of that
  sampling on the name of the column in order to calculate colonization and
  extinction.
}
\examples{
irregular_single_dataset(simberloff[[1]], 3:17, 0.001, 0.001)
irregular_single_dataset(simberloff[[1]], 3:17, column = "Tax. Unit 1",
0.001, 0.001, 3)
\donttest{
irregular_single_dataset(simberloff[[1]], 3:17, column = "Tax. Unit 1",
0.001, 0.001, 3, 0.00001)
}
NLL_isd(simberloff[[1]], 3:17, 0.0038, 0.0086)
}
\seealso{
\code{\link{regular_sampling_scheme}},
  \code{\link{irregular_multiple_datasets}}
}
