% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolines-grob.R
\name{isolines_grob}
\alias{isolines_grob}
\title{Render labeled isolines}
\usage{
isolines_grob(lines, gp = gpar(), breaks = NULL, labels = NULL,
  margin = unit(c(1, 1, 1, 1), "pt"), label_col = NULL,
  label_alpha = NULL, label_placer = label_placer_minmax(),
  units = "npc")
}
\arguments{
\item{lines}{Isolines, as produced by the \code{\link[=isolines]{isolines()}} function.}

\item{gp}{Grid graphical parameters. Parameters applying to lines
(such as \code{col}, \code{lwd}, \code{lty}, etc.) are recycled among the total
number of lines drawn. Parameters applying only to labels (such
as \code{fontfamily}, \code{fontsize}) are recycled among the specified
breaks only. The two parameters \code{col} and \code{alpha} are also applied
to labels, unless overridden (see \code{label_col} and \code{label_alpha}),
but are matched to the corresponding lines.}

\item{breaks}{Character vector specifying the isolines that should be
labeled. If \code{NULL}, labels all isolines.}

\item{labels}{Character vector specifying the labels for each break.
If \code{NULL}, uses the breaks as labels. The number of labels provided
must match the number of breaks provided.}

\item{margin}{Unit object of length 4 specifying the top, right, bottom,
and left margins around each text label. The same margins are applied
to all labels.}

\item{label_col}{Color applied to labels. Can be used to override the
color provided in \code{gp}, in case labels and lines should have different
colors.}

\item{label_alpha}{Alpha applied to labels. Can be used to override the
alpha value provided in \code{gp}, in case labels and lines should have
different alpha values.}

\item{label_placer}{Function that controls how labels are placed along
the isolines. Uses \code{\link[=label_placer_minmax]{label_placer_minmax()}} by default.}

\item{units}{A character string specifying the units in which to
interpret the isolines coordinates. Defaults to \code{"npc"}.}
}
\description{
This function generates a grid grob that represents labeled isolines.
}
\examples{
library(grid)

viridis_pal <- colorRampPalette(
  c("#440154", "#414487", "#2A788E", "#22A884", "#7AD151", "#FDE725"),
  space = "Lab"
)

x <- (1:ncol(volcano))/(ncol(volcano)+1)
y <- (nrow(volcano):1)/(nrow(volcano)+1)
lines <- isolines(x, y, volcano, 5*(19:38))
bands <- isobands(x, y, volcano, 5*(18:38), 5*(19:39))

b <- isobands_grob(
  bands,
  gp = gpar(col = NA, fill = viridis_pal(21), alpha = 0.4)
)
l <- isolines_grob(
  lines, breaks = 20*(5:10),
  gp = gpar(
    lwd = c(.3, 1, .3, .3)
  )
)

grid.newpage()
grid.draw(b)
grid.draw(l)
}
\seealso{
See \code{\link[=isobands_grob]{isobands_grob()}} for drawing of isobands. See \code{\link[=label_placer_minmax]{label_placer_minmax()}} for
label placement strategies.
}
