% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isobxr_solvers.R
\name{num_slvr}
\alias{num_slvr}
\title{Numerically solve stable isotope box models}
\usage{
num_slvr(input_path, to_DIGEST_csv = FALSE, save_run_outputs = FALSE)
}
\arguments{
\item{input_path}{path to the INPUT file containing all commands for the run \cr
(character string, file name structure: \strong{\emph{RUN name + _IN.Rda}})}

\item{to_DIGEST_csv}{Edits csv outputs to the RUN DIGEST folder \cr
(logical, default is FALSE)}

\item{save_run_outputs}{\emph{OPTIONAL} \cr
Logical value. \cr
Allows saving all run outputs to directory containing INPUT file. \cr
By default, run outputs are stored in a temporary directory and are erased if not exported. \cr
Default is FALSE.}
}
\value{
The function returns the numerically determined evolution of stable
isotope compositions and mass of element X in all boxes over the run duration as
specified in INPUT file. \cr  \cr
By default (unless save_run_outputs = TRUE), run outputs are stored in the temporary directory and are not exported. \cr \cr
The outputs of the run are stored in a Rda output file
with the following file name structure:  \cr
\strong{\emph{RUN name + _OUT.Rda}}
}
\description{
A numerical solver of the system of ordinary differential equations (ODES),
describing the evolution of stable isotope ratios in all boxes of a system. \cr
Not intended for direct use although possible. \cr
The numerical solver uses the ode function of the deSolve package
to integrate the stable isotopes ratios over time in each box. It allows the
calculation of the evolution of stable isotope ratio even in the case of
unbalanced outward and inward fluxes of element X in a given box
resulting in the accumulation or loss of element X.
}
\section{Optional csv outputs to the DIGEST folder are as follows}{

\enumerate{
\item OUT data file storing initial and final size and delta values in all boxes.\cr
(file name structure: \strong{\emph{out_1_N_OUT + RUN name + .csv}})
\item evS data file storing the evolution with time of the sizes (masses of element X) of all boxes.\cr
(file name structure:  \strong{\emph{out_2_N_evS + RUN name + .csv}})
\item evD data file storing the evolution with time of the delta values in all boxes.\cr
(file name structure:  \strong{\emph{out_3_N_evD + RUN name + .csv}})
}
}

