% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanAggregateClusterProbability.R
\name{meanAggregateClusterProbability}
\alias{meanAggregateClusterProbability}
\title{Create mean aggregate probability-of-origin surfaces for each cluster.}
\usage{
meanAggregateClusterProbability(indivIDs, clusters, surfaces, nClust = FALSE)
}
\arguments{
\item{indivIDs}{Vector of individual ID variables corresponding to surface names.}

\item{clusters}{Vector of cluster IDs, in an order corresponding to `indivIDs`.}

\item{surfaces}{Stack of probability-of-origin surfaces for all individuals. Object of class 'RasterStack.'}

\item{nClust}{Create and apply a multi-core cluster for faster processing using `raster` and `parallel` packages. Defaults to `FALSE` (i.e., no clustering).}
}
\description{
Subset probability-of-origin surfaces by cluster assignment and find mean aggregate probability-of-origin surface for each clustered group.
}
\examples{
\donttest{
# Create and cluster example assignment surfaces.
myiso <- rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
df <- data.frame(
        ID = LETTERS[1:9],
        isotopeValue = seq(-120,-25,length.out = 9),
        SD_indv = rep(5, 9)
        )
assignmentModels <- isotopeAssignmentModel(
         ID = df$ID,
         isotopeValue = df$isotopeValue,
         SD_indv = df$SD_indv,
         precip_raster = myiso,
         precip_SD_raster = myiso_sd,
         nClusters = FALSE
         )
mySimilarityMatrix <- simmatrixMaker(assignmentModels)
cS <- clusterSimmatrix(
         simmatrix = mySimilarityMatrix,
         r = seq(.7,1.4,by=.1)
         )
# Cut clusters.
myheight <- 0.25
df$cluster <- dendextend::cutree(cS$hclust, h = myheight)
# Create mean aggregate surfaces.r p
meanSurfaces <- meanAggregateClusterProbability(
         indivIDs = df$ID,
         clusters = df$cluster,
         surfaces = assignmentModels,
         nClust = FALSE
         )
}
}
