% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileAtCoordinates.R
\name{quantileAtSamplingLocation}
\alias{quantileAtSamplingLocation}
\alias{quantile_at_point}
\title{Quantile at coordinates function}
\usage{
quantileAtSamplingLocation(indivraster, Lat, Lon)
}
\arguments{
\item{indivraster}{A RasterLayer representing normalized probability of origin surface}

\item{Lat}{Integer latitude}

\item{Lon}{Integer longitude}
}
\description{
Function estimates percentile of each non-NA value within a RasterLayer using the empirical cumulative distribution function, and extracts value at location specified.
For more information, see help(ecdf).
}
\examples{
# Generate example probability surface.
myiso <- raster::rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
exampleSurface <- isotopeAssignmentModel(
         ID = "A",
         isotopeValue = -100,
         SD_indv = 5,
         precip_raster = myiso,
         precip_SD_raster = myiso_sd,
         nClusters = FALSE
         )
# Calculate quantile probability value at specific point.
set.seed(1)
x <- sample( which( !is.na(exampleSurface[]) ), size = 1)
pt <- raster::xyFromCell(exampleSurface, x)
quantileAtSamplingLocation(exampleSurface, Lat = pt[2], Lon = pt[1])


}
\seealso{
\code{\link{makeQuantileSurfaces}}
}
