% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpdb.R
\name{to_VSMOW}
\alias{to_VSMOW}
\title{Converting isotope delta from VPDB to VSMOW}
\usage{
to_VSMOW(d18O_VPDB, eq = "IUPAC")
}
\arguments{
\item{d18O_VPDB}{d18O values expressed on the VPDB scale (‰).}

\item{eq}{Equation used for the conversion.
\itemize{
\item \code{"IUPAC"} (default): the IUPAC recommended equation
listed in Brand et al. (2014) and Kim et al. (2015).
\item \code{"Coplen83"}: the equation listed in Coplen et al. (1983)
and the Hoefs book.
}}
}
\value{
Returns the d18O value expressed on the VSMOW scale (‰).
}
\description{
\code{to_VSMOW()} converts d18O value expressed on the VPDB scale
to the VSMOW scale.
}
\details{
The IUPAC recommended equation to convert between the scales is:

\deqn{\delta^{18}O_{VSMOW} = 1.03092 \times \delta^{18}O_{VPDB} + 30.92}
}
\examples{
to_VSMOW(0)
to_VSMOW(0, eq = "Coplen83")

}
\references{
Coplen, T. B., Kendall, C., & Hopple, J. (1983).
Comparison of stable isotope reference samples.
Nature, 302, 236-238.
\doi{10.1038/302236a0}

Brand, W. A., Coplen, T. B., Vogl, J., Rosner, M., & Prohaska, T. (2014).
Assessment of international reference materials for
isotope-ratio analysis (IUPAC Technical Report).
Pure and Applied Chemistry, 86(3), 425-467.
\doi{10.1515/pac-2013-1023}

Kim, S.-T., Coplen, T. B., & Horita, J. (2015).
Normalization of stable isotope data for carbonate minerals:
Implementation of IUPAC guidelines.
Geochimica et Cosmochimica Acta, 158, 276-289.
\doi{10.1016/j.gca.2015.02.011}
}
\seealso{
\code{\link[=to_VPDB]{to_VPDB()}} converts d18O values expressed
on the VSMOW scale to the VPDB scale.
}
