## -----------------------------------------------------------------------------
# load isoorbi library
library(isoorbi)

## ---- message=FALSE, results='hide'-------------------------------------------
# Path to a test file included in the isoorbi pacakge
file_path <- system.file(package = "isoorbi", "extdata", "testfile_flow.isox")

# Read .isox test data
df <- file_path |> orbi_read_isox() 

# Keep only most important columns; equivalent to simplify check box in IsoX
df.simple <- df |> orbi_simplify_isox()

# Filter the data
df.filtered <- df.simple |> 
  orbi_filter_isox(
    time_min = 0, 
    time_max = 1, 
    compounds = "HSO4-",
    isotopocules = c("M0", "34S", "18O")
  )

# Clean the data by removing noise and outliers
df.clean <- df.filtered |> 
  orbi_filter_satellite_peaks() |> 
  orbi_filter_weak_isotopocules(min_percent = 10) |> 
  orbi_filter_scan_intensity(outlier_percent = 10)

# Define base peak and calculate the results table
df.results <- df.clean |> 
  orbi_define_basepeak(basepeak_def = "M0")|> 
  orbi_summarize_results(ratio_method = "sum")

