% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isosave.R
\name{iso_save}
\alias{iso_save}
\title{Save data to R Data Storage (.rds)}
\usage{
iso_save(iso_files, filepath, quiet = default(quiet))
}
\arguments{
\item{iso_files}{collection of iso_file objects}

\item{filepath}{the path (folder and filename) to the export file. The correct file extension is automatically added if not already in the filename, i.e. filename can be provided with or without extension.}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_message_on} and \link[=iso_info_messages]{iso_turn_info_message_off}}
}
\value{
returns the iso_files object invisibly for use in pipelines
}
\description{
This function saves the passed in iso_files to an R Data Storage (.rds) file, which is an efficient compressed data storage format. Data exported this way can be easily read back into isoreader using the standard \code{\link{iso_read_continuous_flow}} and \code{\link{iso_read_dual_inlet}} functions.
}
\seealso{
Other export functions: 
\code{\link{iso_export_to_excel}()},
\code{\link{iso_export_to_feather}()},
\code{\link{iso_export_to_rda}()}
}
\concept{export functions}
