% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isodata_structures.R
\name{iso_is_file}
\alias{iso_is_file}
\alias{iso_is_file_list}
\alias{iso_is_object}
\alias{iso_is_dual_inlet}
\alias{iso_is_continuous_flow}
\alias{iso_is_scan}
\alias{iso_as_file_list}
\title{Isoreader data structure functions}
\usage{
iso_is_file(x)

iso_is_file_list(x)

iso_is_object(x)

iso_is_dual_inlet(x)

iso_is_continuous_flow(x)

iso_is_scan(x)

iso_as_file_list(..., discard_duplicates = TRUE)
}
\arguments{
\item{x}{an object to test whether it has the specific class}

\item{...}{iso_file and iso_file_list objects to concatenate}

\item{discard_duplicates}{whether to automatically discard files with duplicate file IDs (i.e. duplicate file names). If \code{TRUE} (the default), only the first files are kept and any files with the same file ID are discarded. If \code{FALSE}, all duplicate files are kept but their file IDs are appended with suffix \code{#1}, \code{#2}, etc.}
}
\description{
\code{iso_is_file} tests if the object is an iso_file

\code{iso_is_file_list} tests if the object is an iso_file list (collection of iso_files)

\code{iso_is_object} test if the object is an iso-object (iso_file or iso_file list)

\code{iso_is_dual_inlet} tests if an iso_file or iso_file list consists exclusively of dual inlet file objects

\code{iso_is_continuous_flow} tests if an iso_file or iso_file list consists exclusively of continuous flow file objects

\code{iso_is_scan} tests if an iso_file or iso_file list consists exclusively of scan file objects

\code{iso_as_file_list} concatenates iso_file and iso_file list object(s) into one combined iso_file list (equivalent to calling \code{c(...)}), flattens all passed lists into one list structure, all individual objects and objects within iso_file lists have to be the same type of iso_file, issues warnings if there are duplicate file ids and summarizes all problems in the iso_file list. If duplicates are allowed (\code{discard_duplicates = FALSE}), their file IDs will append a #1, #2, #3, etc. to preserve unique file IDs (important for many data aggregation operations).
}
