% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.import.model}
\alias{isotree.import.model}
\title{Load an Isolation Forest model exported from Python}
\usage{
isotree.import.model(file)
}
\arguments{
\item{file}{Path to the saved isolation forest model.
Must be a file path, not a file connection,
and the character encoding should correspond to the system's native encoding.}
}
\value{
An isolation forest model, as if it had been constructed through
\link{isolation.forest}.
}
\description{
Loads a serialized Isolation Forest model as produced and exported
by the Python version of this package. Note that the metadata must be something
importable in R - e.g. column names must be valid for R (numbers are valid for
Python's pandas, but not for R, for example).

It's recommended to generate a '.metadata' file (passing `add_metada_file=TRUE`) and
to visually inspect said file in any case.

This function is not meant to be used for passing models to and from R -
in such case, one can use `saveRDS` and `readRDS` instead as they will
likely result in smaller file sizes (although this function will still
work correctly for serialization within R).
}
\details{
If the model was fit to a `DataFrame` using Pandas' own Boolean types,
take a look at the metadata to check if these columns will be taken as booleans
(R logicals) or as categoricals with string values `"True"` and `"False"`.

See the documentation for \link{isotree.export.model} for details about compatibility
of the generated files across different machines and versions.

If using this function to de-serialize a model in a production system, one might
want to delete the serialized bytes inside the object afterwards in order to free up memory.
These are under `model$cpp_obj$serialized` (plus `model$cpp_obj$imp_ser` if building with imputer)
- e.g.: `model$cpp_obj$serialized = NULL; model$cpp_obj$imp_ser = NULL; gc()`.
}
\seealso{
\link{isotree.export.model} \link{isotree.restore.handle}
}
