% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data_utility_functions.R
\name{move_n_point}
\alias{move_n_point}
\title{Utility function.}
\usage{
move_n_point(x, n = 1, na_value = NA)
}
\arguments{
\item{x}{A vector.}

\item{n}{Number indicating how many steps the vector should shift forward
(N > 0) or backward (n < 0).}

\item{na_value}{The value to replace the empty cells with (e.g., the first
or last points). Defaults to NA.}
}
\value{
A vector with the same length of \code{x}, all moved \code{n} steps.
}
\description{
Utility function.
}
\examples{
data(simdat)
(test <- simdat[1:20,])
test$Y.prev <- move_n_point(test$Y)
test$change <- test$Y - test$Y.prev
test$Y.post5 <- move_n_point(test$Y, n=-5)

emptyPlot(nrow(test), range(test$Y))
lines(test$Y)
lines(test$Y.prev, col='red')
lines(test$Y.post5, col='blue')
}
\author{
Jacolien van Rij
}
\seealso{
Other Data utility functions: \code{\link{findAbsMin}};
  \code{\link{find_n_neighbors}}; \code{\link{group_sort}};
  \code{\link{print_summary}}; \code{\link{summary_data}}
}

