% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/model_utility_functions.R
\name{convertNonAlphanumeric}
\alias{convertNonAlphanumeric}
\title{Utility unction.}
\usage{
convertNonAlphanumeric(text)
}
\arguments{
\item{text}{A text string (smooth term label) that needs to be converted
to a regular expression.}
}
\value{
A regular expression string.
}
\description{
Utility unction.
}
\examples{
data(simdat)
# Model for illustrating coefficients:
m0 <- bam(Y ~ s(Time) + s(Subject, bs='re')
+ s(Time, Subject, bs='re'), data=simdat)

# get all coefficients:
coef(m0)
# to get only the Subject intercepts:
coef(m0)[grepl(convertNonAlphanumeric("s(Subject)"), names(coef(m0)))]
# to get only the Subject slopes:
coef(m0)[grepl(convertNonAlphanumeric("s(Time,Subject)"), names(coef(m0)))]
}
\author{
Jacolien van Rij
}
\seealso{
Other utility functions: \code{\link{diff_terms}};
  \code{\link{missing_est}}
}

