% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/basic_plots.R
\name{emptyPlot}
\alias{emptyPlot}
\title{Utility function}
\usage{
emptyPlot(xlim, ylim, main = NULL, xlab = NULL, ylab = NULL, h0 = NULL,
  v0 = NULL, bty = "n", eegAxis = FALSE, ...)
}
\arguments{
\item{xlim}{A one- or two-value vector indicating the range of the x-axis.
If \code{xlim} is a number, then it is assumed that the other value is 0.
Thus, \code{xlim=3000} wil result in a x-axis ranging from 0 to 3000,
and \code{xlim=-3} will result in a x-axis ranging from -3 to 0.}

\item{ylim}{A one- or two-value vector indicating the range of the y-axis.
(See \code{xlim}) for more information.}

\item{main}{Title for the plot. Empty by default.
Note: the title can be added later using \code{\link[graphics]{title}}.}

\item{xlab}{Label for x-axis. Empty by default. If no label is provided,
use \code{\link[graphics]{mtext}} for adding axis labels.}

\item{ylab}{Label for y-axis. Empty by default. (See \code{xlab}.)}

\item{h0}{A vector indicating where to add solid horizontal lines for
reference. By default no values provided.}

\item{v0}{A vector indicating where to add dotted vertical lines for
reference. By default no values provided.}

\item{bty}{A character string which determined the type of box which is
drawn about plots. If bty is one of "o", "l", "7", "c", "u", or "]" the
resulting box resembles the corresponding upper case letter. A value of
"n"  (the default) suppresses the box.}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting the
negative amplitudes upwards as traditionally is done in EEG research.
If eeg.axes is TRUE, labels for x- and y-axis are provided, when not
provided by the user. Default value is FALSE.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
An empty plot window.
}
\description{
Generate an empty plot window.
}
\examples{
data(simdat)
test <- simdat[simdat$Subject=='a10' & simdat$Trial==10,]

emptyPlot(range(test$Time), range(test$Y),
main='Data', ylab='Y', xlab='Time',
h0=0, v0=c(0,1000,2000))
# Note that this is the same as:
emptyPlot(range(test$Time), range(test$Y))
title(main='Data', ylab='Y', xlab='Time')
abline(h=0)
abline(v=c(0,1000,2000), lty=3)

# To add data, use lines() and points()
lines(test$Time, test$Y)
}
\author{
Jacolien van Rij
}
\seealso{
Use \code{\link[graphics]{title}} and
\code{\link[graphics]{mtext}}  for drawing labels and titles;
use  \code{\link[graphics]{lines}} and \code{\link[graphics]{points}}
for plotting the data;
use \code{\link[graphics]{legend}} for adding a legend.
and \code{\link{acf_n_plots}} for inspection of individual time series.

Other Utility functions for plotting: \code{\link{addInterval}};
  \code{\link{alphaPalette}}; \code{\link{alpha}};
  \code{\link{color_contour}}; \code{\link{dotplot_error}};
  \code{\link{errorBars}}; \code{\link{fadeRug}};
  \code{\link{fill_area}}; \code{\link{find_difference}};
  \code{\link{getCoords}}; \code{\link{getFigCoords}};
  \code{\link{gradientLegend}}; \code{\link{horiz_error}};
  \code{\link{plot_error}}
}

