% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf.R
\name{derive_timeseries}
\alias{derive_timeseries}
\title{Derive the time series used in the AR1 model.}
\usage{
derive_timeseries(model, AR.start = NULL)
}
\arguments{
\item{model}{GAMM model that includes an AR1 model.}

\item{AR.start}{Vector with AR.start information, 
necessary for the AR1 model. Optional, defaults to NULL.}
}
\value{
A vector with time series indication based on the AR1 model.
}
\description{
Derive the time series used in the AR1 model.
}
\examples{
data(simdat)

# add missing values to simdat:
simdat[sample(nrow(simdat), 15),]$Y <- NA
simdat <- start_event(simdat, event=c("Subject", "Trial"))

\dontrun{
# Run GAMM model:
m1 <- bam(Y ~ te(Time, Trial)+s(Subject, bs='re'), data=simdat, 
    rho=.5, AR.start=simdat$start.event)
simdat$Event <- NA
simdat[!is.na(simdat$Y),]$Event <- derive_timeseries(m1)
acf_resid(m1, split_pred=list(Event=simdat$Event))

# And this works too:
simdat$Event <- derive_timeseries(simdat$start.event)
acf_resid(m1, split_pred=list(Event=simdat$Event))

# Note that acf_resid automatically makes use of derive_timeseries:
acf_resid(m1, split_pred="AR.start")
}
}
\seealso{
Other functions for model criticism: \code{\link{acf_n_plots}},
  \code{\link{acf_plot}}, \code{\link{acf_resid}},
  \code{\link{resid_gam}}, \code{\link{start_event}},
  \code{\link{start_value_rho}}
}
\author{
Jacolien van Rij
}
