% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_monobound.R
\name{groupby}
\alias{groupby}
\title{Auxiliary function: grouping rows in data}
\usage{
groupby(data, variables, groupname = ".mst.monog",
  countname = ".mst.monoc", count = TRUE)
}
\arguments{
\item{data}{\code{data.frame} to which the function will assign
groups to each row.}

\item{variables}{vector of the variable/column names in \code{data}
that will be used to determine the groups.}

\item{groupname}{name of the column that will be generated to
indicate the group.}

\item{countname}{name of the column that will provide a cumulative
count of rows in each group.}

\item{count}{boolean switch, set to \code{TRUE} if the column
\code{countname} should be generated.}
}
\value{
\code{data.frame} containing an additional column
    indicating the group each row falls under. If \code{count} is
    set to \code{TRUE}, then an additional column counting the rows
    within each group is also included.
}
\description{
Auxiliary function that takes in \code{data}, and assigns a group
number to all observations with the same entries in the columns
listed in the vector \code{variables}.
}
