% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_monobound.R
\name{maxminmatch}
\alias{maxminmatch}
\title{Auxiliary function: finding the max/min within a group in a data set}
\usage{
maxminmatch(data, count = ".mst.monoc", group = ".mst.monog", type)
}
\arguments{
\item{data}{\code{data.frame} that user wishes to determine the row
with the largest or smallest ranking within each group.}

\item{count}{string of column name indicating the ranking of each
row within a group.}

\item{group}{string of column name indicating the group of each
row.}

\item{type}{input \code{"max"} to tag the row in each group with
the largest rank, and \code{"min"} to tag the row in each group
with the smallest rank.}
}
\value{
A binary vector indicating whether or not each
    corresponding row in \code{data} is the max/min within its
    group.
}
\description{
This function takes the a data set \code{data}. Assuming the data
has a column with the name stored in the \code{group} argument
indicating the groups (see \code{\link[ivmte]{groupby}}), and a
column with the \code{count} variable that ranks the elements in the
group (data is assumed to be ordered by \code{(group, rank)}); this
function returns a dummy indicator for each row in \code{data} that
equals to 1 if the \code{count} entry matches that of \code{type},
which can either be \code{max} or \code{min} (i.e. either the
largest in the group, or the smallest).
}
