\name{dm.addMigration}
\alias{dm.addMigration}
\title{Add migration/gene flow between two populations to a demographic model}
\usage{
dm.addMigration(dm, lower.range, upper.range, fixed.value, pop.from, pop.to,
  time.start = "0", par.new = T, new.par.name = "M", parameter)
}
\arguments{
  \item{dm}{The demographic model to which recombination
  events should be added.}

  \item{par.new}{If 'TRUE' a new parameter will be created
  using the arguments 'lower.range' and 'upper.range' or
  'fixed.value'. It will be named 'new.par.name'.  If
  'FALSE' the argument 'parameter' will be evaluated
  instead.}

  \item{lower.range}{If you want to estimate the migration
  parameter (see note}

  \item{upper.range}{Same as lower.range, but the largest
  possible value.}

  \item{fixed.value}{If specified, the migration rate will
  not be estimated, but assumed to have the given value.}

  \item{new.par.name}{The name for the new parameter.}

  \item{parameter}{Instead of creating a new parameter, you
  can also set the mutation rate to an expression based on
  existing parameters. For example setting this to "M" will
  use an parameter with name M that you have previously
  created. You can also use R expression here, so "2*M" or
  "5*M+2*tau" (if tau is another parameter) will also work
  (also this does not make much sense).}

  \item{pop.from}{The population from which the individuals
  leave.}

  \item{pop.to}{The population to which the individuals
  move.}

  \item{time.start}{The time point at which the migration
  with this rate starts.}
}
\value{
The demographic model with migration
}
\description{
This function adds the assumption to the model that some
individuals 'migrate' from one sub-population to another,
i.e. they leave the one and become a member of the other.
This is usually used to model ongoing gene flow through
hybridisation after the populations separated.
}
\details{
You can enter a time ('time.start') at which the migration
is assumed to start (looking backwards in time). From that
time on, a fixed number of migrants move from population
'pop.from' to population 'pop.to' each generation. This
number is given via this feature's parameter, which equals
4*Ne*m, where Ne is the number of diploid individuals in
the ancestral population and m is the fraction of 'pop.to'
that is replaced with migrants each generation. If 'pop.to'
has also size Ne, than this is just the expected number of
individuals that migrate each generation.

You can add different mutation rates at different times to
your model. Then each rate will be used for the period from
its time point to the next. Migration from and to an
population always ends with the speciation event in which
the population is created.
}
\examples{
# Constant asymmetric migration
dm <- dm.createThetaTauModel(c(25,25), 100)
dm <- dm.addMigration(dm, 0.01, 5, pop.from=1, pop.to=2, time.start="0")

# Stepwise decreasing mutation
dm <- dm.createThetaTauModel(c(25,25), 100)
dm <- dm.addMigration(dm, 0.01, 5, pop.from=1, pop.to=2, new.par.name="M",
                      time.start="0")
dm <- dm.addMigration(dm, pop.from=1, pop.to=2, par.new=FALSE,
                      parameter="0.5*M", time.start="0.5*tau")
}

