% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaatha.R
\name{jaatha}
\alias{jaatha}
\title{Simulation based maximum likelihood estimation}
\usage{
jaatha(model, data, repetitions = 3, sim = model$get_par_number() * 25,
  max_steps = 100, init_method = c("initial-search", "zoom-in", "middle"),
  cores = 1, verbose = TRUE)
}
\arguments{
\item{model}{The model used for the estimation. 
See \code{\link{create_jaatha_model}}.}

\item{data}{The data used for the estimation.
See \code{\link{create_jaatha_data}}.}

\item{repetitions}{The number of independend optimizations that will be
conducted. You should use a value greater than one here, to minimize
the chance that the algorithms is stuck in a local maximum.}

\item{sim}{The number of simulations conducted for each step.}

\item{max_steps}{The maximal number of steps, in case Jaatha fails to 
converge.}

\item{init_method}{Determines how the starting position of each repetition
is chosen. See below for a description of the different options.}

\item{cores}{The number of CPU cores that will be used for the simulations.
The relies on the \pkg{parallel} package, and consequenlty only one
core is supported on Windows.}

\item{verbose}{If \code{TRUE}, information about the optimization algorithm
is printed.}
}
\value{
TBR
}
\description{
Simulation based maximum likelihood estimation
}
\section{Algorithm}{

  TBR
}

\section{Initialization Methods}{

  TBR
}
\author{
Paul Staab and Lisha Mathew
}

