% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R
\docType{class}
\name{ref_genome}
\alias{ref_genome}
\title{An R6 class representing a reference genome.}
\format{An \code{\link[R6]{R6Class}} generator object}
\usage{
ref_genome
}
\value{
An object of class \code{ref_genome}.
}
\description{
This class should NEVER be created using \code{ref_genome$new}.
Only use \code{read_fasta} or \code{create_genome}.
This class wraps a pointer to a C++ object, which is why
there are no fields to manipulate directly.
All manipulations are done through this class's methods.
}
\section{Methods}{

\strong{Viewing information:}
\describe{
\item{\code{ptr()}}{View the pointer to the reference chromosome information.
This is used internally by \code{jackalope} and shouldn't be of much use to users.}
\item{\code{n_chroms()}}{View the number of chromosomes.}
\item{\code{sizes()}}{View vector of chromosome sizes.}
\item{\code{chrom_names()}}{View vector of chromosome names.}
\item{\code{chrom(chrom_ind)}}{View a chromosome sequence string based on an index,
\code{chrom_ind}.}
\item{\code{gc_prop(chrom_ind, start, end)}}{View the GC proportion for a range within a
reference chromosome.}
\item{\code{nt_prop(nt, chrom_ind, start, end)}}{View the proportion of a range within a
reference chromosome that is of nucleotide \code{nt}.}
}
\strong{Editing information:}
\describe{
\item{\code{set_names(new_names)}}{Set names for all chromosomes.
\code{new_names} is a character vector of what to change names to, and it must
be the same length as the # chromosomes.}
\item{\code{clean_names()}}{Clean chromosome names, converting \code{" :;=\%,\\|/\"\'"}
to \code{"_"}.}
\item{\code{add_chroms(new_chroms, new_names = NULL)}}{Add one or more chromosomes
directly. They can optionally be named (using \code{new_names}).
Otherwise, their names are auto-generated.}
\item{\code{rm_chroms(chrom_names)}}{Remove one or more chromosomes based on names in
the \code{chrom_names} vector.}
\item{\code{merge_chroms()}}{Merge all chromosomes into one after first shuffling
their order.}
\item{\code{filter_chroms(threshold, method)}}{Filter chromosomes by size
(\code{method = "size"}) or for a proportion of total bases (\code{method = "prop"}).
For the latter, chromosomes are first size-sorted, then the largest \code{N}
chromosomes are retained that allow at least
\code{threshold * sum(<all chromosome sizes>)} base pairs remaining after
filtering.}
\item{\code{replace_Ns(pi_tcag, n_threads = 1, show_progress = FALSE)}}{Replace
\code{N}s in reference chromosome with nucleotides sampled with probabilities
given in \code{pi_tcag}.
You can optionally use multiple threads (\code{n_threads} argument) and/or
show a progress bar (\code{show_progress}).}
}
}

\seealso{
\code{\link{read_fasta}} \code{\link{create_genome}}
}
\keyword{datasets}
